/****** Object:  Trigger [TRG_EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT]    Script Date: 08/16/2012 09:47:10 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT]'))
DROP TRIGGER [dbo].[TRG_EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT]
GO
CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT] ON [dbo].[EST_NF_ENT_PRE_ENTRADA_LIB] FOR INSERT AS
	BEGIN
		
		DECLARE @FLAG_WMS INT
		DECLARE @CD_FILIAL INT

		SET @CD_FILIAL = ISNULL((SELECT 
									TOP 1 CD_FILIAL
								 FROM 
									INSERTED i 
									INNER JOIN EST_NF_ENT_PRE_ENTRADA pre_ent on
										i.CD_EMP				 = pre_ent.CD_EMP
										AND i.CD_CTR_PRE_ENTRADA = pre_ent.CD_CTR_PRE_ENTRADA),0)
		
		SET @FLAG_WMS = ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG WHERE CD_EMP = 1 AND CD_FILIAL = @CD_FILIAL AND CD_CHAVE = 'FLAG_UTILIZA_WMS'),0);

		IF @FLAG_WMS = 1 
			BEGIN
				-------------------------------------------------------------------------------
				--Gravando o cabealho da integrao
				-------------------------------------------------------------------------------
				INSERT INTO EST_WMS_ENT (DT_PED, CD_USU, DT_CAD, DT_ULT_ALT, STS_PED, CD_DEST_ORIG, NM_DEST_ORIG)
				SELECT	pre_ent.DT_CAD, 
						pre_ent.CD_USU,
						GETDATE(),
						NULL,
						0,
						CAST ('1' + RIGHT('00000000' + CAST(PG_FORN.CD_FORN AS VARCHAR), 8) AS NUMERIC) AS CD_FORN,
						PG_FORN.RZ_FORN
				FROM INSERTED i INNER JOIN EST_NF_ENT_PRE_ENTRADA pre_ent ON
						i.CD_EMP				 = pre_ent.CD_EMP
						AND i.CD_CTR_PRE_ENTRADA = pre_ent.CD_CTR_PRE_ENTRADA
					INNER JOIN EST_PED_CP ON
						pre_ent.CD_EMP			= EST_PED_CP.CD_EMP
						AND pre_ent.CD_FILIAL	= EST_PED_CP.CD_FILIAL
						AND pre_ent.CD_PED		= EST_PED_CP.CD_PED
					INNER JOIN PG_FORN ON
						EST_PED_CP.CD_EMP		= PG_FORN.CD_EMP
						AND EST_PED_CP.CD_FORN	= PG_FORN.CD_FORN

				-------------------------------------------------------------------------------
				--Gravando os itens da integrao
				-------------------------------------------------------------------------------
				INSERT INTO EST_WMS_ENT_IT (CD_PED_WMS, CD_PROD, LOTE, QT_PROD, CD_EMP, DT_FABRIC, DT_VALID)
				SELECT	IDENT_CURRENT('EST_WMS_ENT'), 
						pre_ent_cpl.CD_PROD,
						ISNULL(pre_ent_lote.CD_LOTE, 'ND') AS LOTE,	
						SUM((CASE WHEN pre_ent_lote.CD_LOTE IS NULL THEN pre_ent_cpl.QT_IT ELSE pre_ent_lote.QT_IT_LT END)),
						pre_ent_cpl.CD_EMP, 
						pre_ent_lote.DT_FABRIC, 
						pre_ent_lote.DT_VALID
				FROM INSERTED i INNER JOIN EST_NF_ENT_PRE_ENTRADA_CPL pre_ent_cpl ON
						i.CD_EMP				 = pre_ent_cpl.CD_EMP
						AND i.CD_CTR_PRE_ENTRADA = pre_ent_cpl.CD_CTR_PRE_ENTRADA
					LEFT JOIN EST_NF_ENT_PRE_ENTRADA_CPL_LOTE pre_ent_lote on
						pre_ent_cpl.CD_EMP					= pre_ent_lote.CD_EMP
						AND pre_ent_cpl.CD_CTR_PRE_ENTRADA 	= pre_ent_lote.CD_CTR_PRE_ENTRADA
						AND pre_ent_cpl.CD_PROD			 	= pre_ent_lote.CD_PROD
				GROUP BY 
					pre_ent_cpl.CD_PROD,
					pre_ent_cpl.CD_EMP,
					pre_ent_lote.CD_LOTE,
					pre_ent_lote.DT_FABRIC, 
					pre_ent_lote.DT_VALID

				-------------------------------------------------------------------------------
				--Gravando os itens da integrao
				-------------------------------------------------------------------------------
				INSERT INTO EST_NF_ENT_PRE_ENTRADA_EST_WMS_ENT (CD_EMP, CD_CTR_PRE_ENTRADA, CD_PED_WMS)
				SELECT	i.CD_EMP, 
						i.CD_CTR_PRE_ENTRADA,
						IDENT_CURRENT('EST_WMS_ENT')
				FROM INSERTED i
			
			END	

	END

 






GO


